<?php

namespace Txd\Opcache\Http\Controllers;

use App\Http\Controllers\Controller;

class OpcacheController extends Controller
{
    public function reset()
    {
        if (function_exists('opcache_reset')) {
            opcache_reset();

            return response()->json(['message' => 'OPCache successfully reset.']);
        }

        return response()->json(['error' => 'OPCache not available.'], 404);
    }

    public function status()
    {
        if (function_exists('opcache_get_status')) {
            return response()->json(['result' => opcache_get_status(false)]);
        }

        return response()->json(['error' => 'OPCache not available.'], 404);
    }
}
