# txdOPCache Package

A Laravel package designed to securely reset OPCache via a middleware-protected route and a custom Artisan command. This allows for secure and efficient management of OPCache clearing, suitable for environments where direct CLI access might be limited.
## Installation

To install the package via Composer, run the following command:

    composer require txd/opcache

## Usage

### Secure OPCache Reset Route

The package adds secure routes that are only accessible from the localhost. This routes can be used to interact with OPCache:

    GET /opcache_reset
    GET /opcache_status

This routes are protected by the LocalhostOnly middleware to ensure they are accessible only from 127.0.0.1 or ::1.

### Custom Artisan Command

You can also reset OPCache using the provided Artisan command, which makes an HTTP request to the secure route:

    php artisan opcache:reset

You can view the status of OPCache by using

    php artisan opcache:status

This command is useful for integrating OPCache management into deployment scripts or other automated processes.

### License

This package is open-source software licensed under the MIT license.