<?php

namespace Txd\Opcache\Provider;

use Illuminate\Support\ServiceProvider;
use Txd\Opcache\Commands\OpcacheResetCommand;
use Txd\Opcache\Commands\OpcacheStatusCommand;
use Txd\Opcache\Http\Middleware\LocalhostOnly;

class PackageServiceProvider extends ServiceProvider
{
    public function register()
    {
        // Register any package-specific services here
    }

    public function boot()
    {
        $this->loadRoutesFrom(__DIR__.'/../routes.php');
        $this->app['router']->aliasMiddleware('localhost', LocalhostOnly::class);

        if ($this->app->runningInConsole()) {
            $this->commands([
                OpcacheResetCommand::class,
                OpcacheStatusCommand::class,
            ]);
        }
    }
}
