<?php

namespace Txd\PassportBackchannel\Client\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Txd\PassportBackchannel\Client\Guards\BackchannelGuard;

class PassportBackchannelClientServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        
        $this->mergeConfigFrom(
            __DIR__.'/../config/passport-backchannel-client.php', 'passport-backchannel-client'
        );
        
        
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        
        $this->publishes([
            __DIR__.'/../config/passport-backchannel-client.php' => config_path('passport-backchannel-client.php')
        ], 'passport-backchannel-client-config');
        
        Auth::extend('backchannel', function ($app, $name, array $config) {
			// Return an instance of Illuminate\Contracts\Auth\Guard...
//			dd($name);
			return new BackchannelGuard(Auth::createUserProvider($config['provider']), $app['request']);
		});
        Auth::extend('backchannel-system', function ($app, $name, array $config) {
			// Return an instance of Illuminate\Contracts\Auth\Guard...
//			dd($name);
			return new BackchannelGuard(null, $app['request']);
		});
    }
}
