<?php

namespace Txd\PassportBackchannel\Listeners;

use App\Models\Passport\Client;
use Illuminate\Auth\Events\Logout;
use Laravel\Passport\Client as PassportClient;
use Laravel\Passport\Passport;
use Txd\PassportBackchannel\BackchannelClient;

class LogoutListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(Logout $event)
    {
        

        $confClients = collect(config('services.oauth_clients'));
        $clientModel = Passport::clientModel();
        $clients = $clientModel::whereIn('id', $confClients->pluck('id'))->get()->keyBy('id');
        $userCallback = app("backchannel-identifier-callback");
        foreach ($confClients as $key => $client) {

            try {
                app(BackchannelClient::class, ['oauthClient' => $clients[$client['id']]])->backchannelCall('logout', userId: $userCallback($event->user));
            } catch (\Throwable $e) {
                // Log::error(__METHOD__, [$e->getMessage(), $e->getTraceAsString(), 'contesto' => context_error_details()]);
            }

        }
    }
}
