<?php

namespace Txd\PassportBackchannel\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Auth\Events\Logout;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Facades\Event;
use Txd\PassportBackchannel\Listeners\LogoutListener;

class PassportBackchannelServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        
        // $this->mergeConfigFrom(
        //     __DIR__.'/../config/passport-backchannel.php', 'passport-backchannel'
        // );
        
        $this->app->singleton("backchannel-identifier-callback", function(){
            return function($user){
                return optional($user)->getKey();
            };
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Event::listen(Logout::class, LogoutListener::class);
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');
        // $this->publishes([
        //     __DIR__.'/../config/passport-backchannel.php' => config_path('passport-backchannel.php')
        // ], 'passport-backchannel-config');
    }
}
