<?php

namespace Txd\PassportBackchannel;

use App\Models\User;
use Laravel\Passport\Client as PassportClient;

class TokenBuilder
{
    public function __construct(protected PassportClient $client, protected ?string $userId = null) {}

    public function logout($userId = null)
    {
        return $this->token(eventName: 'logout', userId: $userId);
    }

    public function token(array $data = [], ?string $eventName = null, $userId = null)
    {
        $payload = [
            'iss' => config('app.url'),
            'aud' => $this->client->getKey(),
            'iat' => time(),
            'sub' => $userId ?? $this->userId,
            'kid' => 'oauth-public',
        ];

        if (!is_null($eventName)) {
            $payload['events'] = [$eventName];
        }
        if (!is_null($data)) {
            $payload['data'] = $data;
        }

        return \Firebase\JWT\JWT::encode(
            $payload,
            file_get_contents(storage_path('oauth-private.key')),
            'RS256',
            'oauth-public'
        );
    }
}
