<?php

namespace Txd\PassportBackchannel;

use App\Models\User;
use DomainException;
use Http;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\InvalidCastException;
use Illuminate\Database\Eloquent\MissingAttributeException;
use Illuminate\Http\Client\PendingRequest;
use Illuminate\Support\Facades\Http as FacadesHttp;
use Laravel\Passport\Client;
use LogicException;
use Txd\Api\Clients\Contracts\AuthStrategy;
use Txd\Api\Clients\HttpClient;

use function Illuminate\Filesystem\join_paths;

/**
 * @property BackchannelStrategy $auth
 * @package Txd\PassportBackchannel
 */
class BackchannelClient extends HttpClient
{
    /** @var null|\Illuminate\Http\Client\PendingRequest */
    protected $_client = null;

    

    public function __construct(Client $oauthClient) {
        $this->withAuth(new BackchannelStrategy($oauthClient));
        parent::__construct([
            "host" => $this->getUrl()
        ]);
    }

    public function oauthClient(){
        return $this->auth->oauthClient;
    }
    

    protected $_url = null;
    
    

    public function getUrl()
    {
        if (is_null($this->_url)) {
            $confClients = collect(config('services.oauth_clients'))->keyBy('id');
            $this->_url = $confClients[$this->oauthClient()->getKey()]['url'] ?? null;
            if (is_null($this->_url)) {
                $url = $this->oauthClient()->redirect_uris[0] ?? null;
                $host = parse_url($url, PHP_URL_HOST);
                $scheme = parse_url($url, PHP_URL_SCHEME);
                $this->_url = "$scheme://$host";
            }
        }

        return $this->_url;
    }
    
    

    /**
     * chiamata alle api /api/backchannel/$eventname. usata per azioni dedicate al canale di backchannel
     *
     * @return mixed
     *
     * @throws InvalidCastException
     * @throws MissingAttributeException
     * @throws LogicException
     * @throws DomainException
     */
    public function backchannelCall(string $eventName, array $payload = [],  $user = null)
    {
        if (!is_null($user)) {
            $this->auth->setUser($user);
            
        }

        return $this->post(join_paths('api', 'backchannel', $eventName), $payload);
    }
}
