<?php

namespace Txd\PassportBackchannel;

use App\Models\User;
use DomainException;
use Http;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\InvalidCastException;
use Illuminate\Database\Eloquent\MissingAttributeException;
use Illuminate\Http\Client\PendingRequest;
use Illuminate\Support\Facades\Http as FacadesHttp;
use Laravel\Passport\Client;
use LogicException;
use Txd\Api\Clients\Contracts\AuthStrategy;
use Txd\Api\Clients\HttpClient;

use function Illuminate\Filesystem\join_paths;

class BackchannelStrategy implements AuthStrategy {
    
    public function __construct(public readonly Client $oauthClient){}
    
    
    protected  $user = null;
    
    
    public function setUser($user = null){
        $this->user = $user;
    }
    
    public function authenticate(PendingRequest $request): PendingRequest
    {
        return $request->withHeaders([
                'kid' => 'oauth-public',
                'key' => route('passport.public_key'),
            ])->withToken($this->token());
    }
    
    protected function token(array $data = [], ?string $eventName = null)
    {
        $callback = app("backchannel-identifier-callback");
        $userId = $callback($this->user);
        $payload = [
            'iss' => config('app.url'),
            'aud' => $this->oauthClient->getKey(),
            'iat' => time(),
            'sub' => $userId,
            'kid' => 'oauth-public',
        ];

        if (!is_null($eventName)) {
            $payload['events'] = [$eventName];
        }
        if (!is_null($data)) {
            $payload['data'] = $data;
        }

        return \Firebase\JWT\JWT::encode(
            $payload,
            file_get_contents(storage_path('oauth-private.key')),
            'RS256',
            'oauth-public'
        );
    }
    
    

    public function handleUnauthorized(HttpClient $client): bool
    {
        return false;
    }

    public function cacheDiscriminator(): string
    {
        $callback = app('backchannel-identifier-callback');
        $userId = $callback(auth()->user());
        $clientId = $this->oauthClient->getKey();

        if (is_null($userId)) {
            return "backchannel.{$clientId}.system";
        }

        return "backchannel.{$clientId}.user.{$userId}";
    }
    
}

