<?php

namespace Txd;
class txdPdfTools {
    
    protected $api_baseurl;
    protected $develop = true;
    
    protected $local_source_file_path = null;
    protected $source_content = null;
    protected $out_filename = "document.pdf";
    protected $out_force_download = false;
    protected $source_pdf_total_page;
    protected $error_messages = [];


	public function __construct(){
        
        // if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
		
		$this->api_baseurl = config("txd_pdf_tools.api_gateway_baseurl");
		$this->develop = config("txd_pdf_tools.develop");
	}

    
    /**
     * imposta il contentuto del PDF da modificare
     *
     * @param string $base64_string
     * @return txdPdfTools
     */
    public function set_source_content($base64_string){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->source_content = $base64_string;
        return $this;
    }

    /**
     * imposta il contentuto del PDF partendo da un file locale
     *
     * @param string $local_file_path
     * @return txdPdfTools
     */
    public function set_source_from_local_file($local_file_path){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->local_source_file_path = $local_file_path;
        $this->source_content = file_get_contents($this->local_source_file_path);
        return $this;
    }


    /**
     *
     * @param string $filename
     * @return txdPdfTools
     */
    public function out_filename($filename){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->out_filename = $filename;
        return $this;
    }

    /**
     *
     * @param bool $force_download
     * @return txdPdfTools
     */
    public function out_force_download($force_download){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->out_force_download = $force_download;
        return $this;
    }


    public function getErrorMessages(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return $this->error_messages;
    }


    /**
     * verifica se il PDF di partenza e' gia' adeguato ad essere manipolato dal componente php o se necessita di un "fix" di formato
     * in caso di errore popola l'array error_messages con le info (recuperabile tramite ->getErrorMessages())
     *
     * @param null|string $local_source_file_path percorso del file locale da analizzare (NULL se e' gia' stato impostato con un metodo ad hoc)
     * @return bool
     */
    public function check_pdf($local_source_file_path = null){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_string($local_source_file_path)){
            $this->local_source_file_path = $local_source_file_path;
        }

        if($this->local_source_file_path === null){
            throw new \Exception("Prima di procedere e' necessario impostare il percorso del file da controllare (o passarlo direttamente al metodo)");
        }

        if(!is_file($this->local_source_file_path)){
            throw new \Exception("File non trovato: ".$this->local_source_file_path);
        }

        try {
            $pdf = new \setasign\Fpdi\Fpdi();
            $this->source_pdf_total_page = $pdf->setSourceFile($this->local_source_file_path);
            
            return true;

        } catch (\Exception $th) {
            $this->error_messages[] = $th->getMessage();
            return false;
        }
    }


    public function pdf_fix($return_as_string = false){
        
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if($this->source_content === null){
            throw new \Exception("Prima di procedere e' necessario impostare un file sorgente, ad esempio utilizzando il metodo set_source_content()");
        }

        $endpoint = $this->api_baseurl."/pdfFix".($this->develop ? "-develop" : "");

        $client = new \GuzzleHttp\Client();

        try {
            
            $response = $client->post($endpoint, [
                'headers' => [
                    'Accept' => 'application/json',
                    // 'Content-Type' => 'multipart/form-data',  // <-- commented out this line
                    // 'Authorization' => 'Bearer '. $userToken,
                ],
                'multipart' => [
                    [
                        'name' => 'uploaded_file',
                        'contents' => $this->source_content,
                    ],
                ],
            ]);

            $headers = [
                "Content-Type"=> "application/pdf",
                "Content-Disposition" => ($this->out_force_download === true ? "attachment; " : "").'filename="'.$this->out_filename.'"',
            ];
            
            if($return_as_string){
                return $response->getBody();
            }else{
                return \Response::make($response->getBody(), 200, $headers);
            }

        } catch(\Exception $e) {
            \Log::error(__METHOD__." | ".$e->getMessage());
            return null;
        }

    }
}