<?php

return [
    'api_gateway_baseurl' => env('PDFTOOLS_API_GATEWAY'),
    'develop' => env('PDFTOOLS_DEVELOP', true),
    'jwt_api_key' => env('PDFTOOLS_API_KEY'),
    'jwt_throw_permission_exception' => true,

    /*
    |--------------------------------------------------------------------------
    | JWT algorithm
    |--------------------------------------------------------------------------
    |
    | Algorithm for sign/check of JWT
    |
    | HS256: shared password
    |
    | RS256: private/public keys
    |
    */
    'jwt_algo' => env('PDFTOOLS_JWT_ALGO', 'HS256'),

    /*
    |--------------------------------------------------------------------------
    | JWT Secret
    |--------------------------------------------------------------------------
    |
    | Chiave segreta per firmare/verificare il JWT (da usare in abbinata all'algoritmo HS256)
    |
    */
    'jwt_secret' => env('PDFTOOLS_JWT_SECRET'), // da usare in caso di algoritmo HS256

    /*
    |--------------------------------------------------------------------------
    | JWT private key
    |--------------------------------------------------------------------------
    |
    | percorso assoluto della chiave privata per firmare il JWT (da usare in abbinata all'algoritmo RS256)
    |
    */
    'jwt_private_key_path' => env('PDFTOOLS_JWT_PK_PATH', storage_path('pdftools-private.key')),

    'jwt_time_validity' => 300, // numero di secondi per i quali e' valido il jwt

    /*
    |--------------------------------------------------------------------------
    | PDF Acroform Base URL
    |--------------------------------------------------------------------------
    |
    | URL del servizio PDF Acroform
    |
    */
    'pdf_acroform_baseurl' => env('PDFTOOLS_ACROFORM_BASEURL', 'http://pdf_acroform:8081/'),

    /*
    |--------------------------------------------------------------------------
    | Use Docker Service
    |--------------------------------------------------------------------------
    | If true, use the Docker service (pdf_acroform) instead of the API Gateway for Lambda calls
    |--------------------------------------------------------------------------
    */
    'use_docker_service' => env('PDFTOOLS_USE_DOCKER_SERVICE', false),

];
