<?php

namespace Txd\Provider;

use Illuminate\Support\ServiceProvider;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class PdfToolsServiceProvider extends ServiceProvider
{
    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {
        if (strpos($this->app->version(), 'Lumen') !== false) {
            $this->app->configure('txd_pdf_tools');
        } else {
            // Publish config files
            $this->publishes([
                __DIR__.'/../../config/txd_pdf_tools.php' => config_path('txd_pdf_tools.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(
            __DIR__.'/../../config/txd_pdf_tools.php', 'txd_pdf_tools'
        );
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register() {}
}
