# PDF AcroForm Overlay Service

Create **fillable PDF forms (AcroForms)** from a normal PDF by placing simple text placeholders (e.g. `##name##`, `##name:20##`) in the document.
The service finds those tokens, hides them, and inserts **text input fields** in the exact positions.

Works great after a DOCX→PDF conversion (e.g., via Gotenberg): you keep your templating flow, then add form fields at the very end.

---

## Features

* **Placeholder-based**:

  * `##name##` → standard text input (default width for \~10 chars)
  * `##name:N##` → text input sized for \~N characters (per-field)
* **Accurate placement** using the PDF text layer (no OCR needed)
* **Borderless fields** by default (can be toggled in code)
* **Stateless HTTP API**: `POST /overlay` with a PDF → returns a modified PDF
* **Fast & concurrent**: Gunicorn + Uvicorn workers; optional Nginx in front

---

## How it works (pipeline)

1. Produce a PDF from your source (DOCX/HTML/etc.).
2. Ensure placeholders like `##name##`, `##surname##`, `##code:5##` appear **as text** in the PDF.
3. Send the PDF to `/overlay`.
4. The service searches each placeholder, draws a white rectangle to hide the token text, and places a **text widget** (AcroForm) right there.
5. You get back a PDF with interactive fields you can fill later (PDFlib, pdftk, PyMuPDF, etc.).

---

## Placeholder syntax

* **Basic**: `##name##`
* **Sized**: `##name:N##` where `N` is the approximate character capacity for the field.

Default when `:N` is omitted: **10**.

> Fields with the **same name** across pages are *linked*: typing in one updates the others (standard AcroForm behavior).

---

#### Query parameters (all optional; sane defaults)

* `placeholder_regex` (string)
  Default: `##([A-Za-z0-9_]+)(?::(\d+))?##`
  (group 1 = field name; group 2 = optional char count)
* `default_chars` (int, default **10**)
  Used when `:N` is not provided
* `font_size` (float, default **10.0**)
  Appearance size for the field’s text
* `char_width_factor` (float, default **0.6**)
  Approx width per char = `font_size * factor`
* `padding_chars` (float, default **2.0**)
  Extra char widths for padding
* `min_w_mm` (float, default **36.0**)
  Minimum field width in millimeters
* `min_h_mm` (float, default **8.0**)
  Minimum field height in millimeters
* `y_offset_up_mm` (float, default **0.0**)
  Positive values move fields **up** to better align with text baselines

#### Response

* **200 OK** with `application/pdf` body
* Headers:

  * `X-Placeholder-Count`: number of fields added

---

## PHP client (Laravel-friendly)

A small fluent client is provided in `App\Services\PdfAcroformClient`.
Usage:

```php
$client = (new \App\Services\PdfAcroformClient())
    ->defaultChars(10)
    ->yOffsetUpMm(1.5)
    ->fontSize(10)
    ->charWidthFactor(0.6)
    ->paddingChars(2.0)
    ->minWidthMm(36)
    ->minHeightMm(8);

return $client->generate(storage_path('app/tmp/test.pdf'), true, 'overlay.pdf');
```

> The client sends the PDF as **multipart** with field name **`file`** (required by the API).
> If you previously used `files` (plural) or sent the **path string** instead of file bytes, you’ll get `422 Field required`.

