<?php

namespace Txd\Querylogger\Provider;

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Support\ServiceProvider;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class TxdQueryLoggerServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot(Kernel $kernel)
    {   
        if (false !== strpos($this->app->version(), 'Lumen')) {
            $this->app->configure('txd_query_logger');
        } else {
            // Publish config files
            $this->publishes([
                __DIR__ . '/../../config/txd_query_logger.php' => config_path('txd_query_logger.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(
			__DIR__.'/../../config/txd_query_logger.php', 'txd_query_logger'
        );

        //aggiungiamolo in fondo ai middleware globali cosi' che sia il primo tra quelli web e prenda anche le query definite in altri middleware
        $kernel->pushMiddleware(\Txd\Querylogger\Middleware\TxdQueryLogger::class);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
		// $this->app['router']->pushMiddlewareToGroup('web', \Txd\Querylogger\Middleware\TxdQueryLogger::class);
    }

}
