<?php

namespace Txd\Querylogger\Provider;

use Illuminate\Support\ServiceProvider;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class TxdQueryLoggerServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {   
        if (false !== strpos($this->app->version(), 'Lumen')) {
            $this->app->configure('txd_query_logger');
        } else {
            // Publish config files
            $this->publishes([
                __DIR__ . '/../../config/txd_query_logger.php' => config_path('txd_query_logger.php'),
            ], 'config');
        }

        $this->mergeConfigFrom(
			__DIR__.'/../../config/txd_query_logger.php', 'txd_query_logger'
        );
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
		$this->app['router']->prependMiddlewareToGroup('web', \Txd\Querylogger\Middleware\TxdQueryLogger::class);
    }

}
