<?php

namespace Txd\Querylogger\Middleware;

use Closure;

use DB;

class TxdQueryLogger
{
    public function handle($request, $next) {

        if(config("txd_query_logger.enabled")){
            DB::connection()->enableQueryLog();
        }

        return $next($request);
    }

    public function terminate($request, $response) {

        if(config("txd_query_logger.enabled")){

            $sent_to_clockwork = false;
            if (config("txd_query_logger.send_to_clockwork") && class_exists("\Clockwork\Support\Vanilla\Clockwork") && function_exists('clock')) {
                clock(inspect_query_stack());
                $sent_to_clockwork = true;
            }

            if(! $sent_to_clockwork || config("txd_query_logger.save_to_file_evenif_clockwork")){
                $queries = DB::getQueryLog();

                $route_info = \Request::route() !== null ? \Request::route()->getName() : request()->fullUrl();

                $filename = preg_replace("/[^a-zA-Z0-9]+/", "-", $route_info)."_query.log";
                $filename_all = "all_query.log";

                if(!\File::isDirectory(config("txd_query_logger.log_save_dir"))){
                    \File::makeDirectory(config("txd_query_logger.log_save_dir"), 0777, true, true);
                }

                // \Log::info($route_info." | numero di query: ".count($queries));
                file_put_contents(config("txd_query_logger.log_save_dir").$filename, "[".date("Y-m-d H:i:s")."] ".$route_info." | numero di query: ".count($queries)."\n", FILE_APPEND | LOCK_EX);
                file_put_contents(config("txd_query_logger.log_save_dir").$filename_all, "[".date("Y-m-d H:i:s")."] ".$route_info." | numero di query: ".count($queries)."\n", FILE_APPEND | LOCK_EX);

                if(config("txd_query_logger.log_all_queries")){

                    collect($queries)->each(function ($query) use ($filename, $filename_all) { 
                        // \Log::info($query);

                        $sql = $query["query"];
                        $dati = $query["bindings"];

                        if(isset($dati) && $dati != null && count($dati) > 0){

                            if(strpos($sql, "?") !== false){

                                //sostituiamo i ? in ordine
                                foreach($dati as $value){
                                    $sql = preg_replace("/\?/", "'".$value."'", $sql, 1);
                                }
                            }else{
                                foreach($dati as $key => $value){
                                    $sql = str_replace(":".$key, "'".$value."'", $sql);
                                }
                            }
                        }

                        file_put_contents(config("txd_query_logger.log_save_dir").$filename, $sql.";\n", FILE_APPEND | LOCK_EX);
                        file_put_contents(config("txd_query_logger.log_save_dir").$filename_all, $sql.";\n", FILE_APPEND | LOCK_EX);

                    });
                }
            }
        }
    }
}
