- [Txd/FieldTypes](#txdfieldtypes)
  - [Installazione](#installazione)
  - [Setup](#setup)
  - [Esempi txdFields](#esempi-txdfields)
    - [Definizione di settori differenti](#definizione-di-settori-differenti)
    - [Inserimento implementazione diversa di un campo in settore specifico](#inserimento-implementazione-diversa-di-un-campo-in-settore-specifico)
    - [Inizializzazione campi per form](#inizializzazione-campi-per-form)
    - [Modifica di un campo già inizializzato](#modifica-di-un-campo-già-inizializzato)
    - [Modifica di tutti i campi di un txdFields](#modifica-di-tutti-i-campi-di-un-txdfields)
    - [Gestione ordinamento](#gestione-ordinamento)
  - [Esempi txdAttributes](#esempi-txdattributes)
    - [Build Mode](#build-mode)
    - [fillable e disabled](#fillable-e-disabled)
# Txd/FieldTypes

Libreria per la gestione centralizzata dei tipi di input.




## Installazione

Aggiungere il repo Techseed al file composer.json

```json
"repositories": [
    { "type": "composer", "url": "https://composer.techseed.it/" }
]
```
installare il pacchetto con composer
```bash
composer install txd/field-types
```
    
## Setup

La libreria sfrutta 2 classi principali _Txd\txdAttributes_ e _Txd\txdFields_, associate ai modelli tramite il trait _Txd\txdModel_.

Un modello con il trait _txdModel_ eredita una serie di metodi che permettono di definire dinamicamente la modalità di stampa e modifica dei suoi attributi. 

Le proprietà di un singolo campo (nome, etichetta, tipologia di stampa...) vengono impostate in una istanza di _Txd\txdAttributes_, mentre l'insieme dei campi e il loro ordinamento vengono gestiti tramite un'istanza di _Txd\txdFields_.

Per definire gli attributi del modello occorre fare un override della funzione db_fields_definition, che da accesso all'istanza _txd\txdFields_ interna al modello.
```php
public function db_fields_definition(\Txd\txdFields $db_fields){
    $db_fields->AddText("nome_campo_1");
    $db_fields->AddText("nome_campo_2","etichetta_campo_2");
    
    $db_fields->addSector("edit",[
        "nome_campo_1",
        "nome_campo_2"
    ]);
}
```
## Esempi txdFields
### Definizione di settori differenti

```php
public function db_fields_definition(\Txd\txdFields $db_fields){
    $db_fields->AddText("nome");
    $db_fields->AddText("cognome");
    $db_fields->AddText("cellulare");
    $db_fields->addSelect("categoria_id")->opzioni_select(["1"=>"Categoria 1","2"=>"Categoria 2"]);
    
    $db_fields->addSector("anagrafica",[
        "nome",
        "cognome",
        "cellulare"
    ]);
    
    $db_fields->addSector("categorie",[
        "categoria_id"
    ]);
    
    $db_fields->addSector("edit",[
        "nome",
        "cognome",
        "cellulare",
        "categoria_id"
    ]);
}
```

### Inserimento implementazione diversa di un campo in settore specifico

```php
public function db_fields_definition(\Txd\txdFields $db_fields){
    $db_fields->AddText("nome");
    $db_fields->AddText("cognome");
    $db_fields->AddText("cellulare");
    $db_fields->addSelect("categoria_id")->opzioni_select(["1"=>"Categoria 1","2"=>"Categoria 2"]);
    
    $db_fields->addSector("edit",[
        "nome",
        "cognome",
        "cellulare",
        "categoria_id"
    ]);
    
    // categoria_id viene rappresentato con un fieldType differente nel settore 'grid'
    $db_fields->addSector("grid",[
        "nome",
        "cognome",
        "cellulare",
        \Txd\FieldTypes\Text::new("categoria_id")
    ]);
    
    // i campi nei settori saranno ordinati secondo l'ordine dell'array
}

/** controller */
// se specifico il settore grid, categoria_id è di tipo Text
$cat = $model->get_campi(["grid"])->retrieve("categoria_id");
$this->assertEquals(get_class($cat), \Txd\FieldTypes\Text::class);

$cat = $model->get_campi("default")->retrieve("categoria_id");
// l'attributo è della tipologia definita inizialmente
$this->assertEquals(get_class($cat), \Txd\FieldTypes\Select::class);

// invocare get_campi senza parametri causa il merge di tutti i settori. Vince l'ultima definizione inserita.
$cat = $model->get_campi()->retrieve("categoria_id");
$this->assertEquals(get_class($cat), \Txd\FieldTypes\Text::class);
```

### Inizializzazione campi per form

gli stili seguenti sono quelli consigliati per l'uso dei settori nei crud o nelle pagine standard.

```php
/** controller */
// modalità standard - settore default
$model = \App\Model\Generic::find(1);
$model->init_db_fields();
/** @var \Txd\txdFields */
$campi = $model->get_campi(); // $campi contiene i campi del settore default

// modalità standard - settore specifico
$model = \App\Model\Generic::find(1);
$model->init_db_fields();
/** @var \Txd\txdFields */
$campi = $model->get_campi("edit"); // $campi contiene i campi del settore "edit"
```

In casi avanzati, è possibile inizializzare nel modello soltanto alcuni settori specifici

```php
/** controller */
$model = \App\Model\Generic::find(1);
$model->init_db_fields("edit");
/** @var \Txd\txdFields */
$campi_default = $model->get_campi(); // è stato inizializzato solo il settore 'edit', quindi $campi_default conterrà solo quelli
/** @var \Txd\txdFields */
$campi = $model->get_campi("edit"); // $campi è uguale a $campi_default
```

Entrambi questi metodi possono accettare un array di settori come input. Questa modalità è tendenzialmente sconsigliata: definisci esplicitamente il settore di cui hai bisogno

```php
$model->init_db_fields(["edit","anagrafica"]);
//...
/** @var \Txd\txdFields */
$campi = $model->get_campi(["edit","anagrafica"]);
```

### Modifica di un campo già inizializzato 
```php
/** controller */
$model = \App\Model\Generic::find(1);
$model->init_db_fields("grid");
/** @var \Txd\txdFields */
$campi = $model->get_campi();
$url = route(/**...*/);

//voglio aggiungere un link a categoria_id, ma nella grid base non deve esserci. lo aggiungo qui
$campi->retrieve("categoria_id")->cellWrap(function($v,$r) use($url){return "<a href='$url'>$v</a>"});
```
### Modifica di tutti i campi di un txdFields
```php
/** controller */
$campi = $model->get_campi();
// voglio rendere tutti i campi readonly
$campi->transformFields(function($field){ return $field->set_build_mode(TXD_ATTRIBUTES_BUILD_MODE::VIEW_ONLY);});
```
### Gestione ordinamento 

```php
public function db_fields_definition(\Txd\txdFields $db_fields){
    $db_fields->AddText("nome");
    $db_fields->AddText("cognome");
    $db_fields->AddText("cellulare")->before("nome");
    $db_fields->AddText("categoria")->after("nome");
    
    // ordine finale: 'cellulare','nome','categoria','cognome'
```

## Esempi txdAttributes
### Build Mode
```php
/** @var \Txd\txdAttributes */
$field->set_build_mode(TXD_ATTRIBUTES_BUILD_MODE::VIEW_ONLY);
// altre opzionI:
//TXD_ATTRIBUTES_BUILD_MODE::VIEW_ONLY
//TXD_ATTRIBUTES_BUILD_MODE::EDIT_ONLY
//TXD_ATTRIBUTES_BUILD_MODE::VIEW_AND_EDIT (default)
```
Questo valore viene salvato nell'attributo pubblico $field_build_mode. Questo valore deve essere considerato dal sistema che stampa il form.

### fillable e disabled

Per gestire se l'attributo è fillable esistono i 2 metodi
```php
$field->fillable(true); // $field->fillable(false);
$field->isFillable() === true;
```
Se l'attributo viene settato come non fillable, il campo è automaticamente disabled.
```php
$field->disabled(true); // $field->fillable(false);
$field->isDisabled() === true;
```
Per impostare in campo come non fillable ma non disabilitato:
```php
$field->fillable(false)->disabled(false);
```

