import { defineConfig, loadEnv } from 'vite'
import vue from '@vitejs/plugin-vue'


import { fileURLToPath, URL } from 'url'

export default defineConfig(({ mode }) => {
  const env = loadEnv(mode, process.cwd(), '')

  return {
    plugins:[
      vue()
    ],
    resolve: {
      alias: [
        { find: '@', replacement: fileURLToPath(new URL('./resources/scripts', import.meta.url)) },
      ]
    },
    
    build:{
      lib:{
        formats:["es"],
        entry: [
          'resources/scripts/subscriptionForm.js',
        ]
      },
      outDir: "dist/form",
      emptyOutDir: true,
      rollupOptions:{
        output:{
          manualChunks: false,
          inlineDynamicImports: true,
          entryFileNames: '[name].js',   // currently does not work for the legacy bundle
          assetFileNames: '[name].[ext]', //
        }
      }
    }
  }
})
