interface Pipe {
  send: (message: string | object, targetName?: string | null) => void;
  received: (message: string | object) => void;
  addListener: (callback: (message: string | object) => void) => void;
  listeners: ((message: string | object) => void)[];
  addTarget: (target: MessageEventSource, targetOrigin: string) => void;
  targets: Record<string, {target:MessageEventSource,targetOrigin:string}>;
}

export function initPipe(name: string, inHostOrigin: string){
    
    function log(...args:Parameters<any>){
      //console.log(performance.now(),name,...args)
    }
  
    let hostOrigin = inHostOrigin
    while(hostOrigin.endsWith("/")){
      hostOrigin = hostOrigin.substring(0,hostOrigin.length - 1)
    }
    
    log("pipe started with host",hostOrigin)
    
    const pipe : Pipe = {
      send(message: string|object,targetName?: string|null){
        
        log("Sending",message)
        if(targetName != null){
          const tgt = this.targets[targetName] ?? null
          if(tgt){
            tgt.target.postMessage(message,tgt.targetOrigin)
          }
        }else{
          for(const t in this.targets){
            const tgt =this.targets[t]
            tgt.target.postMessage(message,tgt.targetOrigin)
          }
        }
        
      },
      received(message: string|object) {
        log("Message received:",message)
        for(const call of this.listeners){
          call(message)
        }
      },
      addListener(callback: (message: string|object) => void){
        this.listeners.push(callback)
      },
      listeners: [],
      addTarget(target: MessageEventSource, targetOrigin: string){
        const interval = setInterval(()=>target.postMessage({type:"TxdPipeHost",name},targetOrigin),500)
        const handler = (event: MessageEvent) => {
          log(event)
          if(event.data.type === "TxdPipeClient"){
            this.targets[event.data?.name] = {target: target,targetOrigin:targetOrigin}
            clearInterval(interval)
            window.removeEventListener("message",handler)
          }
        }
        window.addEventListener("message", handler )
          
        
      },
      targets: {}
    }
     
    window.addEventListener("message", (event: MessageEvent) => {
      log("event",event, event.origin, hostOrigin)
      if (event.origin === hostOrigin && event.data.type === "TxdPipeHost" && event.source != null){
          pipe.targets[event.data.name] = {target:event.source, targetOrigin: hostOrigin}
          event.source.postMessage({type:"TxdPipeClient",name},hostOrigin)
            return
      }else{
        pipe.received(event.data)
      }
    });
    
    
    
    return pipe;
}