import { DataStore } from '@txd/utils'
import Vueform from '@vueform/vueform'
import vueformConfig from '../../vueform.config'
import FormEdit from './FormEdit/FormEdit.vue'
import { createApp } from 'vue'

function init() {        
    const style = document.createElement("link")
    style.rel = "stylesheet"
    style.href = "/scribble/form/style"
    document.querySelector("head").append(style)
    for (const node of document.querySelectorAll("form-edit")) {
        node.dataset.isVue = true
        DataStore.lockAsync(node, 'vue-instance', async () => {
            const propData = {}
            for (const key in node.dataset) {
                if (["isVue"].includes(key)) {
                    continue;
                }
                try {
                    propData[key] = JSON.parse(node.dataset[key])
                } catch (e) {
                    propData[key] = node.dataset[key]
                }
            }

            const app = await createApp(FormEdit, propData)
            
            app.use(Vueform, vueformConfig)
            
            node.addEventListener('remove-vue', function () {
                app.unmount()
                DataStore.remove(node, 'vue-instance')
            })
            app.mount(node, true)
            return app
        })
    }
    setTimeout(()=>{
        document.querySelectorAll(".scribble-form-wrapper").forEach(wrapper => {
            if(wrapper.id){
                ["next","previous"].forEach(function(e){
                    window.addEventListener(e,(event) => {
                        if(event.target.matches("[data-id="+wrapper.id+"]")){
                            wrapper.querySelector(".form-wrapper")?.dispatchEvent(new CustomEvent(e))
                        }
                    },false);
                });
                
                window.addEventListener("click",(event) => {
                    if(event.target.matches("[data-id="+wrapper.id+"]")){
                        wrapper.querySelector(".form-wrapper")?.dispatchEvent(new CustomEvent(event.target.dataset.event =="previous" ?"previous": "next"))
                    }
                },false);
            }
        })
    })
}

export default init
