
import { DataStore } from '@txd/utils'
import { initPipe } from './components/txdPipes';




function initSubscriptionLoader(){
  document.querySelectorAll("[data-scribble-target]").forEach(el => {
    DataStore.lock(el,"subscriptionLoader",()=>{
      loadSubscription(el)
    })
  })
}

initSubscriptionLoader()

window.initSubscriptionLoader = initSubscriptionLoader

function loadSubscription(target){
  let randId = target.dataset.scribbleId;
  if(randId == null){
    randId = Math.floor(Math.random()*9999).toString()
    target.dataset.scribbleId = randId
    
  }
  
  
  const baseUrl = target.dataset.scribbleUrl
  const hostUrl = target.dataset.hostUrl

  const iframe = document.createElement("iframe");
  iframe.name = "scribble_frame_"+randId;
  iframe.id = "scribble_frame_"+randId;
  iframe.style.width = "100%";
  // iframe.style.minHeight = "450px";
  iframe.style.overflowY = "hidden";
  iframe.style.display ="none";


  const waiter = document.createElement("div")
  waiter.classList.add("w-100","d-flex","justify-content-center","mt-5")
  const icon = document.createElement("i")
  icon.classList.add("fas","fa","fa-spin","fa-circle-notch","fa-circle-o-notch","fa-5x")
  icon.setAttribute("alt","Loading data...")
  icon.style.color = "#1b4f6f"
  waiter.appendChild(icon)
  target.appendChild(waiter)
  target.appendChild(iframe)


  const input = document.createElement('input')
  input.type = 'hidden'
  input.name = 'payload'
  input.value = target.dataset.scribbleTarget

  const localeInput = document.createElement('input')
  localeInput.type = 'hidden'
  localeInput.name = 'locale'
  localeInput.value = target.dataset.scribbleLocale

  const form = document.createElement('form') 
  form.target = "scribble_frame_"+randId
  form.method = 'POST'
  form.action = baseUrl+"/subscription/"+target.dataset.scribbleSessionId
  form.appendChild(input)
  form.appendChild(localeInput)

  document.body.appendChild(form)
  form.submit()
  document.body.removeChild(form)

  const pipe = initPipe("booking", hostUrl)
  pipe.addTarget(iframe.contentWindow,baseUrl)

  

  pipe.addListener((message) => {
      if(message.type === "next"){
        target.dispatchEvent(new CustomEvent("next"))  
      }
      
      if(message.type === "error"){
        target.dispatchEvent(new CustomEvent("error"))  
      }
      
      if(message.type === "previous"){
        target.dispatchEvent(new CustomEvent("previous"))  
      }
      
      if(message.type === "ready"){
        
        waiter.style.setProperty("display","none","important")
        iframe.style.display = "block"
        target.dispatchEvent(new CustomEvent("scribble-ready"))
      }
      
      if(message.type === "size"){
        const height = parseInt(message.height)
        iframe.style.height = height + "px"
      }
      
      if(message.type === "submit"){
        target.dispatchEvent(new CustomEvent("scribble-submit",{detail: message.payload}))
      }
      
      if(message.type === "contratto"){
        target.dispatchEvent(new CustomEvent("contratto",{detail: JSON.stringify(message.payload)}))
        
      }
      if(message.type === "quota"){
        target.dispatchEvent(new CustomEvent("quota",{detail: JSON.stringify(message.payload)}))
      }
  })

  target.addEventListener("go-next",()=>{
    pipe.send({type:"next"})
  })
  
  target.addEventListener("go-previous",()=>{
    pipe.send({type:"previous"})
  })
  
  
}