<?php

namespace Scribble\Actions;

use Illuminate\Contracts\Validation\Validator;
use Scribble\Data\IscrizioneData;
use Scribble\Data\ScribbleFormData;
use Scribble\DbManager;
use Scribble\Enums\Permessi;
use Scribble\Models\ScribbleForm;
use Scribble\Utils\Mapper;
use Scribble\Validation\ScribbleFormValidator;

class CalcolaTag
{
    public function __construct(private ?ScribbleFormData $scribbleForm=null) {}
    
    public function initFromViaggio($viaggioId, $version = null){
        app(DbManager::class)->useDb($viaggioId,$version);
        $this->scribbleForm = ScribbleFormData::from(ScribbleForm::with('campi.voci', 'campi.proprieta', 'regole', 'tag', 'mappature')->first());
        
        app(DbManager::class)->cleanUp();
        return $this;
    }

    public function handle(array $dati, ?Mapper $mapper = null)
    {
        if(!is_null($mapper)){
            $dati = $mapper->mapCampiJson($dati);
        }
        $campi = collect($this->scribbleForm->campi);
        return collect($this->scribbleForm->tag)
            ->filter(fn ($t) => $t->condizione->verifica($dati, $this->scribbleForm->campi))
            ->mapWithKeys(function ($t) use ($campi, $dati) {
                $valore = $t->valore;
                if ($t->da_campo) {
                    $campoValore = $campi->first(fn ($c) => $c->id === $t->valore)?->nome;
                    $valore = $dati[$campoValore] ?? null;
                }

                return [
                    $t->nome => [
                        'tag' => $t->nome,
                        'value' => $valore,
                    ],
                ];
            })
            ->toArray();

    }
}
