<?php

namespace Scribble\Actions;

use Illuminate\Contracts\Validation\Validator;
use Scribble\Data\IscrizioneData;
use Scribble\Data\ScribbleFormData;
use Scribble\Enums\Permessi;
use Scribble\Validation\ScribbleFormValidator;

class ProcessaIscrizione
{
    protected CalcolaTag $tagEngine;
    public function __construct(private ScribbleFormData $scribbleForm, private array $voci_terminate = [], private Permessi $permessi = Permessi::Iscritto) {
        $this->tagEngine = new CalcolaTag($scribbleForm);
    }

    public function handle(IscrizioneData $iscrizione, $formData): IscrizioneData
    {

        $campi = collect($this->scribbleForm->campi);
        $formData = array_merge($this->defaults(), $iscrizione->dati, $formData, $iscrizione->external);

        $validator = $this->validator($formData, $this->voci_terminate, $this->permessi);

        $validated = $validator->validated();

        $iscrizione->dati = array_merge($validated, $iscrizione->external);

        $iscrizione->proprieta = $campi->filter(fn ($c) => collect($c->proprieta)->count() > 0)
            ->flatMap(fn ($c) => collect($c->proprieta)->mapWithKeys(fn ($p) => [$p->id => $iscrizione->dati[$c->nome] ?? null]))
            ->toArray();

        $iscrizione->mappature = collect($this->scribbleForm->mappature)->groupBy('gruppo')->map(fn ($arr) => collect($arr)->keyBy('nome')->map(function ($mappatura) use ($campi, $iscrizione) {
            $campo = $campi->first(fn ($c) => $c->id === $mappatura->campo_id);
            if (!is_null($campo)) {
                return $iscrizione->dati[$campo->nome] ?? null;
            }

            return null;
        }))->toArray();

        $iscrizione->tag = $this->tagEngine->handle($iscrizione->dati);

        $iscrizione->esito = true;

        return $iscrizione;
    }

    public function defaults(): array
    {
        return collect($this->scribbleForm->campi)->mapWithKeys(function ($campo) {
            return [$campo->nome => $campo->default];
        })->toArray();
    }

    public function validator($formData, array $voci_terminate = [], Permessi $permessi = Permessi::Iscritto): Validator
    {
        return new ScribbleFormValidator($formData, $this->scribbleForm, $voci_terminate, $permessi);
    }
}
