<?php

namespace Scribble\Data;

use Scribble\Enums\TipiCampi;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class CampoData extends Data
{
    #[Rule('ulid')]
    public string $id;

    #[Rule('ulid')]
    public ?string $scribble_form_id;

    public string $nome;

    /** @var array<string,string> */
    public array $etichetta;

    public ?string $descrizione;

    public TipiCampi $tipo;

    public $default;

    public bool $obbligatorio = false;

    public int $permessi;

    public ?int $ordine;

    public ?int $gruppo;

    public ?int $pagina;

    #[MapInputName('model_exists')]
    public bool $exists;

    public ?array $props;

    /** @var Optional|array<ProprietaData> */
    public Optional|array $proprieta;

    /** @var Optional|array<VoceData> */
    public Optional|array $voci;

    public static function rules()
    {
        return [
            'props.email' => [TipiCampi::Text->excludeUnlessRule(), 'boolean', 'required'],
            'props.codiceFiscale' => [TipiCampi::Text->excludeUnlessRule(), 'boolean'],
            'props.intero' => [TipiCampi::Number->excludeUnlessRule(), 'boolean'],
            'props.min' => [TipiCampi::Number->excludeUnlessRule(), 'nullable', 'numeric'],
            'props.max' => [TipiCampi::Number->excludeUnlessRule(), 'nullable', 'numeric'],
            'props.dataNascita' => [TipiCampi::Date->excludeUnlessRule(), 'boolean'],
            'props.maggiorenne' => [TipiCampi::Date->excludeUnlessRule(), 'boolean'],
        ];
    }
}
