<?php

namespace Scribble\Data;

use Illuminate\Support\Collection;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;

class RegolaData extends Data
{
    #[Rule('ulid')]
    public string $id;

    public bool $exists;

    #[Rule('ulid')]
    public ?string $scribble_form_id;

    public ?string $nome;

    public CondizioneData $condizione;

    /** @var array<int,string> */
    public array $mostra_campi;

    /** @var Collection<int,FiltroVociData> */
    public Collection $filtra_voci;

    public ?string $autogenerata_da;

    public static function rules($context)
    {

        return [
            'mostra_campi' => 'present|array',
        ];
    }

    public function relazioni()
    {
        $deps = $this->filtra_voci->map(function ($filtro) {
            return $filtro->campo;
        })->concat($this->mostra_campi);

        return $this->condizione->campi()->map(fn ($campo) => (object) ['id' => $campo, 'deps' => $deps]);
    }

    public function relazioniInverse()
    {
        $deps = $this->filtra_voci->map(function ($filtro) {
            return $filtro->campo;
        })->concat($this->mostra_campi);

        return $deps->map(fn ($campo) => (object) ['id' => $campo, 'deps' => $this->condizione->campi()]);
    }

    public function campi_in_filtri()
    {
        return $this->filtra_voci->map(fn ($filtro) => $filtro->campo);
    }

    /**
     * Undocumented function
     *
     * @param  array<int|string,RegolaData>|Collection<int|string,RegolaData>  $regole
     */
    public static function alberoRelazioni(array|Collection $regole)
    {
        $relazioni = collect($regole)
            ->flatMap(fn ($regola) => $regola->relazioni())
            ->groupBy('id')
            ->map(fn ($relazioni) => (object) ['id' => $relazioni[0]->id, 'deps' => $relazioni->pluck('deps')->flatten()->unique()]);

        return $relazioni;
    }

    /**
     * Undocumented function
     *
     * @param  array<int|string,RegolaData>|Collection<int|string,RegolaData>  $regole
     */
    public static function alberoRelazioniInverse(array|Collection $regole)
    {
        $relazioni = collect($regole)
            ->flatMap(fn ($regola) => $regola->relazioniInverse())
            ->groupBy('id')
            ->map(fn ($relazioni) => (object) ['id' => $relazioni[0]->id, 'deps' => $relazioni->pluck('deps')->flatten()->unique()]);

        return $relazioni;
    }

    public static function loopCheck(array|Collection $regole)
    {
        $relazioni = RegolaData::alberoRelazioni($regole);

        return $relazioni->some(fn ($r) => static::loopUnit($r, $relazioni, []));
    }

    public static function loopUnit($node, $relazioni, array $history)
    {
        if (in_array($node->id, $history)) {
            return true;
        }

        return $node->deps->some(function ($campo) use ($node, $history, $relazioni) {

            if ($campo == null) {
                return false;
            }
            if (in_array($campo, $history)) {
                return true;
            }
            $subRel = $relazioni[$campo] ?? null;
            if ($subRel == null) {
                return false;
            }

            return static::loopUnit($subRel, $relazioni, [...$history, $node->id]);
        });
    }
}
