<?php

namespace Scribble\Data;

use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class ScribbleFormData extends Data
{
    #[Rule('ulid')]
    public string $id;

    public string $nome;

    public string $viaggio_id;

    /** @var array<CampoData> */
    public array $campi;

    /** @var array<RegolaData> */
    public array $regole;

    /** @var array<TagData> */
    public array $tag;

    /** @var Optional|array<MappaturaData> */
    public Optional|array $mappature;
}
