<?php

namespace Scribble\Data;

use Scribble\Enums\Layout;
use Scribble\Enums\Permessi;
use Scribble\Models\Campo;
use Scribble\Utils\Mapper;

class SessionData {
    protected array $metadata_json = [];
    
    protected ?Mapper $_mapper = null;
    
    
    public function __construct(
        public string $id,
        public $viaggioId = null,
        public Permessi $permessi = Permessi::SolaLettura, // 'creazione'|'sola_lettura'|'iscritto'|'segretario_zona'|'segretario_centrale'|'root'
        public Layout $layout = Layout::Default,
        public array $formData = [],
        public array $externalData = [],
        public $locale = "it",
        public array $campiContratto = [],
        public array $campiQuota = [],
        public $vociTerminate = [],
        public ?string $redirect = null
        
    ){
        
    }
    
    protected function mapper(){
        if(is_null($this->_mapper)){
            $this->_mapper = new Mapper;
        }
        return $this->_mapper;
    }
    
    public static function from(array $data){
        $session = new SessionData(...$data);
        
        return $session;
    }
    
    public static function new(array $data){
        $session = static::from($data);
        $session->id = $session->id ?? \Illuminate\Support\Str::password(10,true,true,false);
        
        return $session;
    }
    
    
    
    public function mapData(array $rawData){
        $this->formData = $this->mapper()->mapCampiJson($rawData);
    }
    public function mapExternalData(array $rawData){
        $this->externalData = $this->mapper()->mapCampiJson($rawData);
    }
    public function mapCampiContratto(array $rawData){
        $this->campiContratto = $this->mapper()->mapCampiArray($rawData);
    }
    public function mapCampiQuota(array $rawData){
        $this->campiQuota = $this->mapper()->mapCampiArray($rawData);
    }
    
    public function metadata(string $key, $default = null): mixed
    {
        $subkey = strtok($key, '.');
        $data = $this->metadata_json ?? [];
        $keyParts = explode('.', $key);
        foreach ($keyParts as $subkey) {
            if (is_array($data) && array_key_exists($subkey, $data)) {
                $data = $data[$subkey];
            } else {
                return $default;
            }
        }

        return $data;
    }

    public function setMetadata(string $key, $value): static
    {
        $setter = function (string $subkey, $value, array $array) use (&$setter) {
            $currentKey = strtok($subkey, '.');
            if (\Illuminate\Support\Str::contains($subkey, '.')) {
                $currentValue = $setter(\Illuminate\Support\Str::replace($currentKey.'.', '', $subkey), $value, $array[$currentKey] ?? []);
                $array[$currentKey] = $currentValue;

            } else {
                $array[$currentKey] = $value;
            }

            return $array;
        };
        $this->metadata_json = $setter($key, $value, $this->metadata_json ?? []);

        return $this;
    }

    public function clearMetadata(string $key): static
    {
        $cleaner = function (string $subkey, array $array) use (&$cleaner) {
            $currentKey = strtok($subkey, '.');
            if (\Illuminate\Support\Str::contains($subkey, '.')) {
                $currentValue = $cleaner(\Illuminate\Support\Str::replace($currentKey.'.', '', $subkey), $array[$currentKey] ?? []);
                if (is_array($currentValue) && count($currentValue) == 0) {
                    unset($array[$currentKey]);
                } else {
                    $array[$currentKey] = $currentValue;
                }

            } else {
                unset($array[$currentKey]);
            }

            return $array;
        };
        $this->metadata_json = $cleaner($key, $this->metadata_json ?? []);

        return $this;
    }
}