<?php

namespace Scribble\Enums;

enum Permessi: string
{
    case Creazione = 'creazione';
    case SolaLettura = 'sola_lettura';
    case Iscritto = 'iscritto';
    case SegretarioZona = 'segretario_zona';
    case SegretarioCentrale = 'segretario_centrale';
    case GestioneUtentiSpeciali = 'utenti_speciali';
    case Root = 'root';

    public function canEdit(int $permessiCampo): bool
    {

        if ($this == self::SolaLettura) {
            return false;
        }
        if ($this == self::Root || $this == self::Creazione) {
            return true;
        }
        $livello = array_search($this, [
            self::Iscritto,
            self::SegretarioZona,
            self::SegretarioCentrale,
            self::GestioneUtentiSpeciali,
        ]);

        return (($permessiCampo >> $livello) & 1) == true;
    }
}
