<?php

namespace Scribble\Enums;

enum TipiCampi: string
{
    case Text = 'text';
    case TextArea = 'textarea';
    case Number = 'number';
    case Date = 'date';
    case Checkbox = 'checkbox';
    case Select = 'select';
    case Hidden = 'hidden';
    case Static = 'static';

    public function excludeUnlessRule(string $prefixPath = '')
    {
        if (strlen($prefixPath) > 0) {
            $prefixPath .= '.';
        }

        return "exclude_unless:{$prefixPath}tipo,{$this->value}";
    }

    public function requiredIfRule(string $prefixPath = '')
    {
        if (strlen($prefixPath) > 0) {
            $prefixPath .= '.';
        }

        return "required_if:{$prefixPath}tipo,{$this->value}";
    }
}
