<?php

namespace Scribble;


use Scribble\Actions\ProcessaIscrizione;
use Scribble\Data\IscrizioneData;
use Scribble\Data\ScribbleFormData;
use Scribble\Data\SessionData;

use Scribble\Models\ScribbleForm;

use Scribble\View\Components\ScribbleFormEdit;
use Illuminate\Support\Str;
use Txd\Layout\Container;

class FormManager
{
    protected ScribbleForm $_form;
    public function __construct(protected DbManager $db){
        
    }
    
    public function load($sessionId,$viaggioId = null) : SessionData {
        $scribbleSession = session()->get(config("scribble.session_key").".{$sessionId}",SessionData::from(["id" => $sessionId,"viaggioId" => $viaggioId]));
        if(!is_a($scribbleSession,SessionData::class)){
            $scribbleSession = SessionData::from(["id" => $sessionId,"viaggioId" => $viaggioId]);
        }
        $this->db->useDb($scribbleSession->viaggioId);
        return $scribbleSession;
    }
    
    public function save(SessionData $session){ 
        
        session()->put(config("scribble.session_key").".{$session->id}",$session);
    }
    
    
    public function initFromSession(SessionData $session){
        /** @var ScribbleForm */
        $scribbleForm = ScribbleForm::with(["campi.voci","regole"])->where('viaggio_id', $session->viaggioId)->first();
        $this->_form = $scribbleForm;
        $iscrizione = new IscrizioneData;
        $iscrizione->session_id = $session->id;
        $iscrizione->scribble_form_id = $scribbleForm->getKey();
        $iscrizione->dati = $session->formData;

        $notEditableData = $scribbleForm->campi->filter(fn ($campo) => !$session->permessi->canEdit($campo->permessi))
            ->keyBy('nome')->map(fn ($campo) => $session->formData[$campo->nome] ?? null)->toArray();

        $iscrizione->external = array_merge($notEditableData, $session->externalData);
        
        return $iscrizione;
    }
    
    public function formFromSession(SessionData $session){
        $iscrizione = $this->initFromSession($session);
        
        /** @var ScribbleForm */
        $scribbleForm = $this->_form;
        $permessi = $session->permessi;

        $formComponent = new ScribbleFormEdit($scribbleForm, $permessi);

        $formComponent->setSessionId($session->id)
            ->fromIscrizione($iscrizione)
            ->setCampiContratto($session->campiContratto)
            ->setCampiQuota($session->campiQuota)
            ->setVociTerminate($session->vociTerminate)
            ->setLayout($session->layout)
            ->setLocale($session->locale);
        
        $scribbleForm = new Container([$formComponent,"<script type='module'>
            (await import('/scribble/form')).default()
        </script>"]);
        $scribbleForm->htmlProperties()->addHtmlClass('scribble-form-wrapper')->setHtmlId("sf_".Str::random(8));
        

        return $scribbleForm;
    }
    
    public function validateFromSession(SessionData $session, $requestData){
        $iscrizione = $this->initFromSession($session);
        
        $scribbleForm = ScribbleForm::find($iscrizione->scribble_form_id);
        $formData = ScribbleFormData::from(ScribbleForm::with('campi.voci', 'campi.proprieta', 'regole', 'tag', 'mappature')->find($scribbleForm->getKey()));
        $action = new ProcessaIscrizione($formData, $session->vociTerminate, $session->permessi);

        $action->handle($iscrizione, $requestData);
        return $iscrizione;
    }
    
    public function saveValidationResults(IscrizioneData $iscrizione){
        $key = "sfv_".Str::random(8);
        session()->flash(config('scribble.session_key').".validated.{$key}", $iscrizione);
        return $key;
    }
    
    public function getValidationResults(string $key): ?IscrizioneData {
        return session()->get(config('scribble.session_key').".validated.{$key}",null);
    }
}
