<?php

namespace Scribble\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Scribble\Contracts\ScribbleFormControllerContract;
use Scribble\Data\IscrizioneData;
use Scribble\FormManager;


class ScribbleFormController extends Controller implements ScribbleFormControllerContract
{
    use AuthorizesRequests, ValidatesRequests;

    
    public function contract($session_id)
    {
        return ['type' => 'contratto', 'payload' => null];

    }

    public function amount($session_id)
    {
        return ['type' => 'quota', 'payload' => null];
    }
    
    public function save(Request $request, $session_id){
        $scribbleSession = app(FormManager::class)->load($session_id);
        
        /** @var IscrizioneData */
        $iscrizione = app(FormManager::class)->validateFromSession($scribbleSession,$request->all());
        
        if (!is_null($scribbleSession->redirect)) {
            $key = app(FormManager::class)->saveValidationResults($iscrizione);
            $url = $scribbleSession->redirect."?key=$key";
        } else {
            $url = null;
        }

        return response()->json(array_filter(['status' => 'OK', 'redirect' => $url]));
    }
}
