<?php

namespace Scribble\Http\Controllers;

use Scribble\Actions\GeneraSchemaForm;
use Scribble\Actions\ProcessaIscrizione;
use Scribble\View\Components\ScribbleFormEdit;
use Illuminate\Contracts\Encryption\DecryptException;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Scribble\Data\IscrizioneData;
use Scribble\Data\ScribbleFormData;
use Scribble\Enums\Layout;
use Scribble\Enums\Permessi;
use Scribble\Models\ScribbleForm;
use Scribble\Utils\LZW;

class StaticController extends Controller
{
    use AuthorizesRequests, ValidatesRequests;

    public function loader()
    {
        /** @var Illuminate\Foundation\Vite */
        $vite = app('Illuminate\Foundation\Vite');
        $js = '';
        $direct = '';
        if ($vite->isRunningHot()) {
            $scripts = $vite(['resources/scripts/subscriptionLoader.js']);

            $re = '/src="([\w\/:\-\.\+@]+)"/m';

            preg_match_all($re, $scripts, $matches, PREG_SET_ORDER, 0);

            $js = '';
            $direct = '';
            foreach ($matches as $match) {
                $path = $match[1];
                $js .= "import \"$path\";\n";
            }
        } else {
            $direct = file_get_contents(__DIR__."/../../../dist/subscriptionLoader.js");
        }

        return response($js."\n".$direct, 200, ['Content-Type' => 'text/javascript']);
    }
    public function form()
    {
        
        /** @var Illuminate\Foundation\Vite */
        $vite = app('Illuminate\Foundation\Vite');
        $js = '';
        $direct = '';
        if ($vite->isRunningHot()) {
            $scripts = $vite(['resources/scripts/subscriptionForm.js']);

            $re = '/src="([\w\/:\-\.\+@]+)"/m';

            preg_match_all($re, $scripts, $matches, PREG_SET_ORDER, 0);

            $js = '';
            $direct = '';
            foreach ($matches as $match) {
                $path = $match[1];
                $js .= "import \"$path\";\n";
            }
        } else {
            
            $direct = "const process = {env: {NODE_ENV:'production'}};
            
             ".file_get_contents(__DIR__."/../../../dist/form/subscriptionForm.js");
             
             $direct = str_replace("if (!confirm(m.value.translations","debugger;if (!confirm(m.value.translations",$direct);
        }

        return response($js."\n".$direct, 200, ['Content-Type' => 'text/javascript']);
    }
    public function formStyle()
    {
        
        /** @var Illuminate\Foundation\Vite */
        $vite = app('Illuminate\Foundation\Vite');
        $js = '';
        $direct = '';
        if ($vite->isRunningHot()) {
            $scripts = $vite(['resources/sass/main.scss']);

            $re = '/src="([\w\/:\-\.\+@]+)"/m';

            preg_match_all($re, $scripts, $matches, PREG_SET_ORDER, 0);

            $js = '';
            $direct = '';
            foreach ($matches as $match) {
                $path = $match[1];
                $js .= "import \"$path\";\n";
            }
        } else {
            $direct = file_get_contents(__DIR__."/../../../dist/form/style.css");
            $direct = str_replace(":root","",$direct);
        }

        return response($js."\n".$direct, 200, ['Content-Type' => 'text/css']);
    }
}
