<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Concerns\HasUlids;
use Illuminate\Database\Eloquent\Model;
use Txd\Traits\OptionSelectTrait;

/**
 * Class Campo
 *
 * @property \Scribble\Casts\CleanHtmlOutput $id
 * @property \Scribble\Casts\CleanHtmlOutput $scribble_form_id
 * @property \Scribble\Casts\CleanHtmlOutput $nome
 * @property array $etichetta
 * @property \Scribble\Casts\CleanHtmlOutput|null $descrizione
 * @property \Scribble\Casts\CleanHtmlOutput $tipo
 * @property array|null $props
 * @property array|null $default
 * @property bool $obbligatorio
 * @property int $permessi
 * @property int|null $ordine
 * @property int|null $gruppo
 * @property int|null $pagina
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * @property ScribbleForm $scribble_form
 * @property Collection|Mappatura[] $mappature
 * @property Collection|Proprieta[] $proprieta
 * @property Collection|Voce[] $voci
 */
class Campo extends Model
{
    use HasUlids;

    protected $table = 'campi';

    public $incrementing = false;

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    use OptionSelectTrait;

    protected $casts = [
        'nome' => 'Scribble\\Casts\\CleanHtmlOutput',
        'etichetta' => 'array',
        'descrizione' => 'Scribble\\Casts\\CleanHtmlOutput',
        'tipo' => 'Scribble\\Casts\\CleanHtmlOutput',
        'props' => 'array',
        'default' => 'array',
        'obbligatorio' => 'bool',
        'permessi' => 'int',
        'ordine' => 'int',
        'gruppo' => 'int',
        'pagina' => 'int',
    ];

    public static function scopeOrdineForm($query)
    {
        return $query->orderBy('pagina')->orderBy('gruppo')->orderBy('ordine');
    }

    public function scribble_form()
    {
        return $this->belongsTo(ScribbleForm::class, 'scribble_form_id', 'id');
    }

    public function mappature()
    {
        return $this->hasMany(Mappatura::class, 'campo_id', 'id');

    }

    public function proprieta()
    {
        return $this->belongsToMany(Proprieta::class, 'proprieta_campi', 'campo_id', 'proprieta_id');
    }

    public function regole_where_autogenerata_da()
    {
        return $this->hasMany(Regola::class, 'autogenerata_da', 'id');

    }

    public function voci()
    {
        return $this->hasMany(Voce::class, 'campo_id', 'id');

    }
}
