<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Model;
use Txd\Traits\OptionSelectTrait;

/**
 * Class Mappatura
 *
 * @property int $id
 * @property \Scribble\Casts\CleanHtmlOutput $scribble_form_id
 * @property \Scribble\Casts\CleanHtmlOutput $nome
 * @property \Scribble\Casts\CleanHtmlOutput $gruppo
 * @property \Scribble\Casts\CleanHtmlOutput|null $campo_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property Campo|null $campo
 * @property ScribbleForm $scribble_form
 */
class Mappatura extends Model
{
    use OptionSelectTrait;

    protected $table = 'mappature';

    protected $casts = [
        'nome' => 'Scribble\\Casts\\CleanHtmlOutput',
        'gruppo' => 'Scribble\\Casts\\CleanHtmlOutput',
    ];

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    public function campo()
    {
        return $this->belongsTo(Campo::class, 'campo_id', 'id');
    }

    public function scribble_form()
    {
        return $this->belongsTo(ScribbleForm::class, 'scribble_form_id', 'id');
    }
}
