<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Model;
use Txd\Traits\OptionSelectTrait;

/**
 * Class Proprieta
 *
 * @property \Scribble\Casts\CleanHtmlOutput $id
 * @property \Scribble\Casts\CleanHtmlOutput $nome
 * @property \Scribble\Casts\CleanHtmlOutput|null $categoria
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property int $ordinamento
 * @property bool $obbligatoria
 * @property Collection|Campo[] $campi
 */
class Proprieta extends Model
{
    use OptionSelectTrait;

    protected $table = 'proprieta';

    public $incrementing = false;

    protected $casts = [
        'nome' => 'Scribble\\Casts\\CleanHtmlOutput',
        'categoria' => 'Scribble\\Casts\\CleanHtmlOutput',
        'ordinamento' => 'int',
        'obbligatoria' => 'bool',
    ];

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    public function campi()
    {
        return $this->belongsToMany(Campo::class, 'proprieta_campi', 'proprieta_id', 'campo_id');
    }
}
