<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Concerns\HasUlids;
use Illuminate\Database\Eloquent\Model;
use Txd\Traits\OptionSelectTrait;

/**
 * Class Regola
 *
 * @property \Scribble\Casts\CleanHtmlOutput $id
 * @property \Scribble\Casts\CleanHtmlOutput $scribble_form_id
 * @property \Scribble\Casts\CleanHtmlOutput|null $nome
 * @property array $condizione
 * @property array $mostra_campi
 * @property array $filtra_voci
 * @property \Scribble\Casts\CleanHtmlOutput|null $autogenerata_da
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * @property ScribbleForm $scribble_form
 */
class Regola extends Model
{
    use HasUlids;
    use OptionSelectTrait;

    protected $table = 'regole';

    public $incrementing = false;

    protected $casts = [
        'nome' => 'Scribble\\Casts\\CleanHtmlOutput',
        'condizione' => 'array',
        'mostra_campi' => 'array',
        'filtra_voci' => 'array',
    ];

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    public static function campi_in_condizione($condizione)
    {
        if ($condizione['group'] ?? false) {
            return collect($condizione['children'])->flatMap(fn ($c) => static::campi_in_condizione($c))->toArray();
        } else {
            return [$condizione['field']];
        }
    }

    protected $__campi_in_condizione = null;

    public function get_campi_in_condizione($force = false)
    {
        if ($force || is_null($this->__campi_in_condizione)) {

            $this->__campi_in_condizione = static::campi_in_condizione($this->condizione);
        }

        return $this->__campi_in_condizione;
    }

    protected $__campi_in_azioni = null;

    public function scribble_form()
    {
        return $this->belongsTo(ScribbleForm::class, 'scribble_form_id', 'id');
    }
}
