<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Concerns\HasUlids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Scribble\Enums\Permessi as EnumsPermessi;
use Txd\Traits\OptionSelectTrait;

/**
 * Class ScribbleForm
 *
 * @property \Scribble\Casts\CleanHtmlOutput $id
 * @property int $viaggio_id
 * @property string $sync
 * @property \Scribble\Casts\CleanHtmlOutput $nome
 * @property array|null $lingue
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property Collection|Campo[] $campi
 * @property Collection|Mappatura[] $mappature
 * @property Collection|Regola[] $regole
 * @property Collection|Tag[] $tag
 */
class ScribbleForm extends Model
{
    use HasFactory;
    use HasUlids;
    use OptionSelectTrait;

    protected $table = 'scribble_form';

    public $incrementing = false;

    protected $casts = [
        'nome' => 'Scribble\\Casts\\CleanHtmlOutput',
        'lingue' => 'array',
    ];

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    public static function forgetSchemaCache($scribbleFormId)
    {
        $esito = false;
        foreach (EnumsPermessi::cases() as $permesso) {
            $esito = Cache::forget("schema_form.{$scribbleFormId}.{$permesso->value}") || $esito;
        }

        return $esito;
    }

    public function campi()
    {
        /** @var Model */
        $self = $this;

        return $self->hasMany(Campo::class, 'scribble_form_id', 'id');

    }

    public function mappature()
    {
        /** @var Model */
        $self = $this;

        return $self->hasMany(Mappatura::class, 'scribble_form_id', 'id');

    }

    public function regole()
    {
        /** @var Model */
        $self = $this;

        return $self->hasMany(Regola::class, 'scribble_form_id', 'id');

    }

    public function tag()
    {
        /** @var Model */
        $self = $this;

        return $self->hasMany(Tag::class, 'scribble_form_id', 'id');

    }
}
