<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Model;
use Txd\Traits\OptionSelectTrait;

/**
 * Class Tag
 *
 * @property int $id
 * @property \Scribble\Casts\CleanHtmlOutput $scribble_form_id
 * @property array $condizione
 * @property \Scribble\Casts\CleanHtmlOutput $nome
 * @property \Scribble\Casts\CleanHtmlOutput|null $valore
 * @property bool $da_campo
 * @property \Scribble\Casts\CleanHtmlOutput|null $descrizione
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property ScribbleForm $scribble_form
 */
class Tag extends Model
{
    use OptionSelectTrait;

    protected $table = 'tag';

    protected $casts = [
        'condizione' => 'array',
        'nome' => 'Scribble\\Casts\\CleanHtmlOutput',
        'valore' => 'Scribble\\Casts\\CleanHtmlOutput',
        'da_campo' => 'bool',
        'descrizione' => 'Scribble\\Casts\\CleanHtmlOutput',
    ];

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    public function scribble_form()
    {
        return $this->belongsTo(ScribbleForm::class, 'scribble_form_id', 'id');
    }
}
