<?php

namespace Scribble\Models;

use Illuminate\Database\Eloquent\Concerns\HasUlids;
use Illuminate\Database\Eloquent\Model;
use Txd\Traits\OptionSelectTrait;

/**
 * Class Voce
 *
 * @property \Scribble\Casts\CleanHtmlOutput $id
 * @property \Scribble\Casts\CleanHtmlOutput $campo_id
 * @property \Scribble\Casts\CleanHtmlOutput $valore
 * @property array $etichetta
 * @property int|null $ordine
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * @property Campo $campo
 */
class Voce extends Model
{
    use HasUlids;
    use OptionSelectTrait;

    protected $table = 'voci';

    public $incrementing = false;

    protected $casts = [
        'valore' => 'Scribble\\Casts\\CleanHtmlOutput',
        'etichetta' => 'array',
        'ordine' => 'int',
    ];

    public function getConnectionName()
    {
        return config('scribble.connection.name');
    }

    public function campo()
    {
        return $this->belongsTo(Campo::class, 'campo_id', 'id');
    }
}
