<?php

namespace Scribble\Providers;

use Illuminate\Support\ServiceProvider;
use Scribble\DbManager;
use Scribble\FormManager;

class ScribbleServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        
        $this->mergeConfigFrom(
            __DIR__.'/../config/scribble.php', 'scribble'
        );
        
        $this->app->singleton(DbManager::class,fn() => 
            new DbManager()
        );
        
        $this->app->singleton(FormManager::class,fn() => 
            new FormManager(app(DbManager::class))
        );
        
        $this->app->instance("scribble-auth-token", function(){
            return new class {
                public function get(){
                    return \Firebase\JWT\JWT::encode(['iss' => config('scribble.auth.issuer')], config('scribble.auth.key'), 'HS256');  
                }
                public function headers(){
                    return [];
                }
            };
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');
        $this->publishes([
            __DIR__.'/../config/scribble.php' => config_path('scribble.php')
        ], 'scribble-config');
    }

    public function registerRoutes()
    {

        if ($this->app instanceof CachesRoutes && $this->app->routesAreCached()) {
            return;
        }

        $attributes = $attributes ?: ['middleware' => ['web']];
        $toLog = function ($token) {
            if (!is_null($token) && ($token === config('broadcasting.connections.pusher.options.hook_token'))) {
                $events = request()->input('events', []);
                \Log::info('Pusher Hook | '.json_encode($events));

                return 'OK';
            }

            return 'KO';
        };

        $this->app['router']->group($attributes, function ($router) use ($toLog) {
            $router->match(
                ['get', 'post'], 'socket_events/{token?}',
                $this->app['config']->get('broadcasting.connections.pusher.options.hook_method') ?? $toLog
            )->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class])
                ->name('pusher.hook');

            $router->match(
                ['post'], 'broadcasting/config',
                fn () => pusher_config(),
            )->name('pusher.config');
        });
    }
}
