<?php

namespace Scribble\Rules;

use Scribble\Data\FiltroVociComportamento;
use Scribble\Data\FiltroVociData;
use Closure;
use Illuminate\Contracts\Validation\DataAwareRule;
use Illuminate\Contracts\Validation\ValidationRule;

class CondizioneFiltraRule implements DataAwareRule, ValidationRule
{
    public function __construct(protected $idCondizione, protected FiltroVociData $filtro) {}

    protected $data = [];

    public function setData(array $data): static
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        $condizioneAttiva = $this->data[$this->idCondizione] ?? false;

        $condizioneNascondi = $condizioneAttiva && $this->filtro->comportamento === FiltroVociComportamento::Nascondi;
        $condizioneMostra = (!$condizioneAttiva) && $this->filtro->comportamento === FiltroVociComportamento::Mostra;

        if ($condizioneMostra || $condizioneNascondi) {
            if (in_array($value, $this->filtro->voci)) {
                $fail('Il campo :attribute non ha un valore riconosciuto');
            }
        }
    }
}
