<?php
namespace Scribble\Utils;

use Scribble\DbManager;
use Scribble\Models\Campo;

class Mapper {
    public function initFromViaggio($viaggioId, $version = null){
        app(DbManager::class)->useDb($viaggioId,$version);
        $this->mapping();
        app(DbManager::class)->cleanUp();
        return $this;
    }
    protected $_mapping = null;
    public function mapping(){
        if(is_null($this->_mapping)){
            $this->_mapping = Campo::pluck('nome', 'id');    
        }
        return $this->_mapping;
    }
    public function mapCampiJson(array $rawJson){
        $mapping = $this->mapping();
        return collect($rawJson)->keyBy(fn ($el, $key) => $mapping[$key])->toArray();
    }
    public function mapCampiArray(array $rawArray){
        $mapping = $this->mapping();
        return collect($rawArray)->map(fn ($el) => $mapping[$el])->toArray();
    }
    
}
