<?php

namespace Scribble\View\Components;

use Scribble\Actions\GeneraSchemaForm;
use Scribble\Utils\LZW;
use Scribble\Data\IscrizioneData;
use Scribble\Enums\Layout;
use Scribble\Enums\Permessi;
use Scribble\Models\ScribbleForm;
use Illuminate\Contracts\Support\Htmlable;
use Txd\Layout\VueTag;

class ScribbleFormEdit extends VueTag implements Htmlable
{
    protected ?IscrizioneData $iscrizione;

    protected array $campi_contratto = [];

    protected array $voci_terminate = [];

    protected array $campi_quota = [];

    protected string $locale = 'it';

    protected string|int|null $session_id = null;

    protected Layout $layout = Layout::Default;

    public function __construct(protected ?ScribbleForm $form = null, protected ?Permessi $permessi = null)
    {
        $this->contents = [];
        $this->tag = 'form-edit';
        
        $this->htmlProperties()->addHtmlStyle('display', 'contents');
    }

    public function toHtml()
    {
        return $this->__toString();
    }

    public function fromFormModel(ScribbleForm $form)
    {
        $this->form = $form;

        return $this;
    }

    public function setPermessi(Permessi $permessi)
    {
        $this->permessi = $permessi;

        return $this;
    }

    public function fromIscrizione(IscrizioneData $iscrizione)
    {
        $this->iscrizione = $iscrizione;

        return $this;
    }

    public function setCampiContratto(?array $campi)
    {
        $this->campi_contratto = $campi ?? [];

        return $this;
    }

    public function setVociTerminate(?array $voci)
    {
        $this->voci_terminate = $voci ?? [];

        return $this;
    }

    public function setCampiQuota(?array $campi)
    {
        $this->campi_quota = $campi ?? [];

        return $this;
    }

    public function setSessionId(string|int $session_id)
    {
        $this->session_id = $session_id;

        return $this;
    }

    public function setLocale(?string $locale)
    {
        $this->locale = $locale ?? "it";

        return $this;
    }

    public function setLayout(?Layout $layout)
    {
        $this->layout = $layout ?? Layout::Default;

        return $this;
    }

    public function render()
    {
        $builder = app(GeneraSchemaForm::class);

        [$schema,$liste,$default] = $builder->handle($this->form, $this->permessi, array_keys($this->iscrizione?->external), $this->voci_terminate);
        $session_id = $this->session_id;
        $formData = [
            'session_id' => $session_id,
            'schema' => $schema,
            'liste' => $liste,
            'defaultValues' => $default,
            'modelValue' => array_merge($this->iscrizione?->dati ?? [], $this->iscrizione?->external ?? []),
            'campi_contratto' => $this->campi_contratto,
            'campi_quote' => $this->campi_contratto,
        ];

        $compressed = app(LZW::class)->compress(json_encode($formData));
        $data = array_map(fn ($n) => dechex($n), $compressed->toArray());
        $payload = implode('|', $data);
        $this->addProp('payload', $payload);
        $this->addProp('form', $this->form->getKey());
        $this->addProp('locale', $this->locale);
        if ($this->permessi === Permessi::SolaLettura) {
            $this->htmlProperties()->addHtmlAttribute('data-readonly');
        }
        $this->addProp('layout', $this->layout->value);

        return parent::render();
    }
}
