<?php

return [
    'host' => env('SCRIBBLE_HOST', 'https://scribble.avvenimenti.org/'),
    'storage_path' => storage_path('scribble_cache'),
    'cache_key' => "scribble_cache",
    'session_key' => "scribble_session",
    'web' => [
        'controller' => \Scribble\Http\Controllers\ScribbleFormController::class,
        'middleware' => ["web"]
    ],
    'auth' => [
        'issuer' => env('SCRIBBLE_AUTH_ISSUER'),
        'key' => env('SCRIBBLE_AUTH_KEY'),
    ],
    
    'connection' => [
        'name' => 'scribble',
        'template' => [
            'driver' => 'sqlite',
            'database' => '',
            'prefix' => '',
            'foreign_key_constraints' => true,
        ],
    ],
];
