import { defineConfig, loadEnv } from 'vite'
import vue from '@vitejs/plugin-vue'


import { fileURLToPath, URL } from 'url'

export default defineConfig(({ mode }) => {
  const env = loadEnv(mode, process.cwd(), '')

  return {
    plugins:[
      vue()
    ],
    resolve: {
      alias: [
        { find: '@', replacement: fileURLToPath(new URL('./resources/scripts', import.meta.url)) },
      ]
    },
    
    build:{
      lib:{
        formats:["es"],
        entry: [
          'resources/sass/main.scss',
        ]
      },
      outDir: "dist/form",
      emptyOutDir: false,
      rollupOptions:{
        output:{
          manualChunks: false,
          assetFileNames: '[name].[ext]', //
        }
      }
    },
    css: {
      preprocessorOptions: {
        scss: {
          quietDeps: true
        }
      }
    }
  }
})
