import { defineConfig, loadEnv } from 'vite'



import { fileURLToPath, URL } from 'url'

export default defineConfig(({ mode }) => {
  const env = loadEnv(mode, process.cwd(), '')

  return {
    resolve: {
      alias: [
        { find: '@', replacement: fileURLToPath(new URL('./resources/scripts', import.meta.url)) }
      ]
    },
    
    build:{
      lib:{
        formats:["es"],
        entry: 'resources/scripts/subscriptionLoader.js'
      },
      outDir: "dist/loader",
      emptyOutDir: true,
      rollupOptions:{
        output:{
          manualChunks: false,
          inlineDynamicImports: true,
          entryFileNames: '[name].js',   // currently does not work for the legacy bundle
          assetFileNames: '[name].[ext]', //
        }
      }
    }
  }
})
