// vueform.config.(js|ts)

import it from '@vueform/vueform/locales/it'
import en from '@vueform/vueform/locales/en'
import es from '@vueform/vueform/locales/es'
import pt from '@vueform/vueform/locales/pt'
import bootstrap from '@vueform/vueform/dist/bootstrap'
import { defineConfig, Validator  } from '@vueform/vueform'
import CustomHiddenElement from '@/FormEdit/FormElements/CustomHiddenElement.vue'


const codiceFiscale = class extends Validator {
  lastValue : string|null = null
  get msg(){
    return "Il codice fiscale inserito non sembra essere valido. Potrebbe essere errato"
  }
   check(value: string) {
    value = (value??'').toUpperCase().trim();
    if(this.lastValue===value){
      return true
    }
    
    this.lastValue = value
    
    if(value == null || value.length ==0){
      return true
    }
    
    if (value.length !== 16){
      return false;
    }
   
    const regex = /^[A-Z]{6}[0-9]{2}[A-Z][0-9]{2}[A-Z][0-9]{3}[A-Z]$/;
    if (regex.exec(value) === null) {
      return false
    }
    
    const indiciOmocodia = [6,7,9,10,12,13,14];
    const ListaDecOmocodia = { 
      'L': '0', 'M': '1', 'N': '2', 'P': '3', 
      'Q': '4', 'R': '5', 'S': '6', 'T': '7', 'U': '8', 'V': '9'
    };
    
    const checkOmocodia = indiciOmocodia.some(idx => {
      if(isNaN(parseInt(value[idx]))){
        if(!Object.keys(ListaDecOmocodia).includes(value[idx])){
          return true;
        }
      }
      
      return false;
    });
    if(checkOmocodia){
      return false;
    }

    const set1 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const set2 = "ABCDEFGHIJABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const setpari = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const setdisp = "BAKPLCQDREVOSFTGUHMINJWZYX";
    let s = 0;

    for (let i = 1; i <= 13; i += 2){
      s += setpari.indexOf(set2.charAt(set1.indexOf(value.charAt(i))));
    }
    for (let i = 0; i <= 14; i += 2){
      s += setdisp.indexOf(set2.charAt(set1.indexOf(value.charAt(i))));
    }

    if (s % 26 != value.charCodeAt(15) - 'A'.charCodeAt(0)){
      return false;
    }

    return true;
  }
}

export default defineConfig({
  elements:[
    CustomHiddenElement
  ],
  theme: bootstrap,
  locales: { it: { ...it, vueform: { ...it.vueform, steps: { finish: 'Invia', previous: 'Indietro', next: 'Continua' } } }, en, es, pt },
  locale: 'it',
  fallbackLocale: 'it',
  rules:{
    codiceFiscale
  },
  addClasses: {
    
    TextElement: {container:"vf-col-12 vf-col-sm-6"},
    TextAreaElement: {container: "vf-col-12 vf-col-sm-6"},
    NumberElement: {container: "vf-col-12 vf-col-sm-6"},
    CheckboxElement: {container: "vf-col-12 vf-col-sm-6"},
    SelectElement: {container: "vf-col-12 vf-col-sm-6"},
    CustomHiddenElement: {container: "d-none"},
    StaticElement: {container: "vf-col-12 vf-col-sm-6"},
    DateElement: {container: "vf-col-12 vf-col-sm-6"},
  },
  presets: {
    
    compact: {
      columns:{
        label: 4
      },
      addClasses:{
        GroupElement:{
          container: "m-00",
          innerWrapper: "vf-col-12",
        }        
      },
      removeClasses:{
        TextElement: {container:"vf-col-sm-6"},
        TextAreaElement: {container: "vf-col-sm-6"},
        NumberElement: {container: "vf-col-sm-6"},
        CheckboxElement: {container: "vf-col-sm-6"},
        SelectElement: {container: "vf-col-sm-6"},
        StaticElement: {container: "vf-col-sm-6"},
        DateElement: {container: "vf-col-sm-6"},
      }
    },
    segretari: {
      columns:{
        label: 4
      },
      addClasses:{
        GroupElement:{
          container: "m-00",
          innerWrapper: "vf-col-12",
        }        
      },
      removeClasses:{
        TextElement: {container:"vf-col-sm-6"},
        TextAreaElement: {container: "vf-col-sm-6"},
        NumberElement: {container: "vf-col-sm-6"},
        CheckboxElement: {container: "vf-col-sm-6"},
        SelectElement: {container: "vf-col-sm-6"},
        StaticElement: {container: "vf-col-sm-6"},
        DateElement: {container: "vf-col-sm-6"},
      }
    },
    readonly: {
      addClasses:{
        ElementLayout:{
          innerWrapper: "no-input",
          innerWrapperAfter: "d-none"
        }
      }
    }
  }
})
