<?php

namespace Txd\Settings;

use Exception;
use Txd\Settings\Contracts\Driver;
use Txd\Settings\Drivers\Config;
use Txd\Settings\Drivers\Database;

/**
 * @mixin \Illuminate\Contracts\Cache\Repository
 */
class SettingsManager
{
    /**
     * The application instance.
     *
     * @var \Illuminate\Contracts\Foundation\Application
     */
    protected $app;

    /**
     * The array of resolved cache stores.
     *
     * @var array
     */
    protected $drivers = [];

    public static $driverOptions = [
        'database' => Database::class,
        'config' => Config::class,
    ];

    /**
     * Create a new Cache manager instance.
     *
     * @param  \Illuminate\Contracts\Foundation\Application  $app
     * @return void
     */
    public function __construct($app)
    {
        $this->app = $app;

    }

    public function driver($driver = null): Driver
    {
        if (is_null($driver)) {
            $driver = $this->app['config']['txd-settings.default_driver'];
        }
        if (!array_key_exists($driver, $this->drivers)) {
            if (array_key_exists($driver, static::$driverOptions)) {
                $driverClass = static::$driverOptions[$driver];
                $this->drivers[$driver] = new $driverClass($this->app['config']["txd-settings.drivers.$driver"]);
            } else {
                throw new Exception("Txd\Settings Driver '$driver' not defined", 500);
            }
        }

        return $this->drivers[$driver];
    }

    /**
     * Dynamically call the default driver instance.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     */
    public function __call($method, $parameters)
    {
        return $this->driver()->$method(...$parameters);
    }
}
