<?php

namespace Txd\Settings\Contracts;

interface Driver
{
    public function set(string $key, mixed $value, string $group = 'default', bool $replace = false): void;

    public function get(string $key, string $group = 'default'): mixed;

    public function list(string $key, string $group = 'default'): \Illuminate\Support\Collection;

    public function enable(string $key, $value, string $group = 'default'): bool;

    public function disable(string $key, $value = null, string $group = 'default'): bool;
}
