<?php

namespace Txd\Tags\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Txd\Tags\Traits\HasTags;

/**
 * Class Tag
 *
 * @property int $id
 * @property string $name
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property HasMany $taggables
 */
class Tag extends Model
{
    protected $table = 'tags';

    protected $model_rules = [
        'id' => [
            'integer',
            'max:1.844674407371E+19',
            'min:0',
        ],
        'name' => [
            'required',
            'max:255',
        ],
        'created_at' => [
            'nullable',
            'date',
        ],
        'updated_at' => [
            'nullable',
            'date',
        ],
    ];

    protected $fillable = [
        'name',
    ];

    public function taggables(): HasMany
    {
        return $this->hasMany(HasTags::getPivotModelClassName(), 'tag_id', 'id');

    }
}
